<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('std_absence_procedures_main_items', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('student_procedure_id');
            $table->unsignedBigInteger('procedure_id');
            $table->enum('status',['done','not_done']);
            $table->timestamps();
            $table->softDeletes();

            $table->foreign('student_procedure_id')->references('id')->on('students_absence_procedures')->onDelete('cascade');
            $table->foreign('procedure_id')->references('id')->on('absence_procedures')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('std_absence_procedures_main_items');
    }
};
