<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('media_suggestions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('school_id');
            $table->foreign('school_id', 'fk_school_id_8')
            ->references('id')->on('schools')
                ->cascadeOnDelete();
            $table->foreignId('semester_id');
            $table->foreign('semester_id', 'fk_semester_6')
            ->references('id')->on('semesters')
                ->cascadeOnDelete();
            $table->text('details');
            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('media_suggestions');
    }
};
