<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('exams_namazeg_monitor_distribution_assignments', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('namazeg_version_id');
            $table->foreignId('school_id')->constrained('schools')->onDelete('cascade');
            $table->unsignedBigInteger('semester_id')->nullable();
            $table->timestamps();
            $table->softDeletes();

            $table->foreign('semester_id','semester_fk')->references('id')->on('semesters')->onDelete('cascade');

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('exams_namazeg_monitor_distribution_assignments');
    }
};
