<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tasks', function (Blueprint $table) {
            $table->id();
            $table->string('date');
            $table->string('details');
            $table->foreignId('school_id');
            $table->foreign('school_id', 'fk_school_id_6')
                ->references('id')->on('schools')
                ->cascadeOnDelete();
            $table->boolean('appointed'); // تم اضافتها لمفركة المواعيد ام لا
            $table->boolean('achieved')->default(false); // checked
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tasks');
    }
};
