<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('exams_student_committee_data', function (Blueprint $table) {
            $table->id();
            $table->foreignId('student_committee')->constrained('exams_student_committees_table')->onDelete('cascade');
            $table->foreignId('student_id')->constrained('school_students')->onDelete('cascade');
            $table->integer('column_number')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('exams_student_committee_data');
    }
};
