<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('exams_student_committees_table', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('namazeg_version_id');
            $table->foreignId('school_id')->constrained()->onDelete('cascade');
            $table->foreignId('semester_id')->constrained()->onDelete('cascade');
            $table->foreignId('schoolclass_id')->nullable()->constrained('school_classes')->onDelete('cascade');
            $table->string('name')->nullable();
            $table->string('committee_student_type')->nullable();
            $table->string('location')->nullable();
            $table->string('formation_type')->nullable();
            $table->string('status')->nullable()->default('incomplated');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('exams_student_committees_table');
    }
};
