<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('exams_namazeg_teacher_question_assignment_subjects', function (Blueprint $table) {
            $table->id();
            $table->foreignId('tqa_assignment_id')
                ->constrained('exams_namazeg_teacher_question_assignments')
                ->name('tqa_assignment_fk') // Custom name for this FK
                ->nullable()
                ->onDelete('cascade')
                ->comment('References id from exam_namazeg_teacher_question_assignments table');

            $table->foreignId('subject_id')
                ->constrained('subjects')
                ->name('subject_fk') // Custom name for this FK
                ->nullable()
                ->onDelete('cascade');

            $table->foreignId('class_name_id')
                ->constrained('class_names')
                ->name('class_name_fk') // Custom name for this FK
                ->nullable()
                ->onDelete('cascade');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('exams_namazeg_teacher_question_assignment_subjects');
    }
};
