<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('exams_correction_committee_assignments', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('namazeg_version_id');
            $table->unsignedBigInteger('school_id');
            $table->string('round')->nullable()->default('الأول')->comment('indicating whether the assignment is for the first or second round of exams');
            $table->unsignedBigInteger('subject_id')->nullable();
            $table->string('location')->nullable();
 
            $table->timestamps();

            $table->foreign('school_id')->references('id')->on('schools')->onDelete('cascade');
            $table->foreign('subject_id')->references('id')->on('subjects')->onDelete('cascade');

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('exams_correction_committee_assignments');
    }
};
