<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('violation_student_titles', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('violation_student_id');
            $table->string('date');
            $table->unsignedInteger('violation_title_id')->nullable();
       
            $table->foreign('violation_student_id','fk_delete violation student')->references('id')->on('violation_students')->onDelete('cascade');
            $table->timestamps();   
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('violation_student_titles');
    }
};
