<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('violation_students', function (Blueprint $table) {
            $table->id();
            $table->unsignedInteger('student_id');
            $table->unsignedInteger('school_id');
            $table->unsignedInteger('violation_grade_id');
            $table->string('date');
            $table->unsignedInteger('violation_type_id')->nullable();
            $table->unsignedInteger('violation_category_id');
            $table->string('other_type')->nullable();
            $table->string('violation_title_ids')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('violation_students');
    }
};
