<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('related_violations', function (Blueprint $table) {
            $table->id();
            $table->foreignId('relation_violation_titles_id')->constrained('violation_titles')->onDelete('cascade');
            $table->unsignedInteger('violation_titles_id')->nullable();
            $table->foreignId('violation_punishment_id')->constrained('namazeg')->onDelete('cascade');
            $table->enum('addition_related',['addition', 'related'])->default('addition');//addition =>added to this relation - related it is already related to violation 
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('related_violations');
    }
};
