<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // First, remove the foreign key constraint on the violation_title_id column
        Schema::table('violation_types', function (Blueprint $table) {
            $table->dropForeign(['violation_title_id']); // Drop the foreign key constraint
        });

        // Add the new column
        Schema::table('violation_types', function (Blueprint $table) {
            $table->unsignedBigInteger('violation_grade_id')->after('id')->nullable();
        });

        // Copy data from the old column to the new column
        DB::statement('UPDATE violation_types SET violation_grade_id = violation_title_id');

        // After copying data, drop the old column
        Schema::table('violation_types', function (Blueprint $table) {
            $table->dropColumn('violation_title_id');
        });

        // Add the foreign key to the new column
        Schema::table('violation_types', function (Blueprint $table) {
            $table->foreign('violation_grade_id')->references('id')->on('violation_grades')->onDelete('cascade');
        });
    }


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {

        Schema::table('violation_types', function (Blueprint $table) {
            // Add the old column back
            $table->unsignedBigInteger('violation_title_id')->nullable();
        });

        // Copy data back from the new column to the old column
        DB::statement('UPDATE violation_types SET violation_title_id = violation_grade_id');

        Schema::table('violation_types', function (Blueprint $table) {
            // Drop the new column
            $table->dropColumn('violation_grade_id');

            // Restore the foreign key to the old column
            $table->foreign('violation_title_id')->references('id')->on('violation_titles')->onDelete('cascade');
        });

    }
};