<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('class_visit_rates', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('classVisit_id')->nullable();
            $table->text('lesson_title_rate')->nullable();
            $table->integer('number_of_class_students')->nullable();
            $table->integer('number_of_attendees')->nullable();
            $table->integer('number_of_absences')->nullable();
            $table->integer('visit_number')->nullable();
            $table->string('purpose_of_visit')->nullable();
            $table->enum('class_visit_meeting_teacher', ['yes', 'no'])->default('yes');
            $table->enum('know_participation_subject_activities', ['yes', 'no'])->default('yes');
            $table->enum('review_written_preparation_lesson', ['yes', 'no'])->default('yes');
            $table->enum('discussion_school_manager', ['yes', 'no'])->default('yes');
            $table->enum('view_assignments_applications', ['yes', 'no'])->default('yes');
            $table->enum('visit_student_mentor', ['yes', 'no'])->default('yes');
            $table->enum('view_calendar_tests', ['yes', 'no'])->default('yes');
            $table->enum('responsibility_rate', [1, 2, 3, 4, 5])->nullable();
            $table->text('responsibility_desc')->nullable();
            $table->enum('communication_collaboration_rate', [1, 2, 3, 4, 5])->nullable();
            $table->text('communication_collaboration_desc')->nullable();
            $table->enum('adherence_dialogue_etiquette_verbally_and_writing_rate', [1, 2, 3, 4, 5])->nullable();
            $table->text('adherence_dialogue_etiquette_verbally_and_writing_desc')->nullable();
            $table->enum('development_rate', [1, 2, 3, 4, 5])->nullable();
            $table->text('development_desc')->nullable();
            $table->enum('exchanging_experiences_rate', [1, 2, 3, 4, 5])->nullable();
            $table->text('exchanging_experiences_desc')->nullable();
            $table->enum('providing_knowledge_production_rate', [1, 2, 3, 4, 5])->nullable();
            $table->text('providing_knowledge_production_desc')->nullable();
            $table->enum('design_course_plan_rate', [1, 2, 3, 4, 5])->nullable();
            $table->text('design_course_plan_desc')->nullable();
            $table->enum('lesson_preparing_rate', [1, 2, 3, 4, 5])->nullable();
            $table->text('lesson_preparing_desc')->nullable();
            $table->enum('preparation_learning_objectives_rate', [1, 2, 3, 4, 5])->nullable();
            $table->text('preparation_learning_objectives_desc')->nullable();
            $table->enum('implementing_lesson_achieves_rate', [1, 2, 3, 4, 5])->nullable();
            $table->text('implementing_lesson_achieves_desc')->nullable();
            $table->enum('employing_educational_techniques_rate', [1, 2, 3, 4, 5])->nullable();
            $table->text('employing_educational_techniques_desc')->nullable();
            $table->enum('using_distance_education_platforms_rate', [1, 2, 3, 4, 5])->nullable();
            $table->text('using_distance_education_platforms_desc')->nullable();
            $table->enum('providing_scientific_material_rate', [1, 2, 3, 4, 5])->nullable();
            $table->text('providing_scientific_material_desc')->nullable();
            $table->enum('apply_educational_strategies_rate', [1, 2, 3, 4, 5])->nullable();
            $table->text('apply_educational_strategies_desc')->nullable();
            $table->enum('linking_lesson_real_life_rate', [1, 2, 3, 4, 5])->nullable();
            $table->text('linking_lesson_real_life_desc')->nullable();
            $table->enum('asking_appropriate_class_questions_rate', [1, 2, 3, 4, 5])->nullable();
            $table->text('asking_appropriate_class_questions_desc')->nullable();
            $table->enum('involving_students_lesson_activities_rate', [1, 2, 3, 4, 5])->nullable();
            $table->text('involving_students_lesson_activities_desc')->nullable();
            $table->enum('evaluating_learning_diagnose_student_rate', [1, 2, 3, 4, 5])->nullable();
            $table->text('evaluating_learning_diagnose_student_desc')->nullable();
            $table->enum('building_integrated_plan_rate', [1, 2, 3, 4, 5])->nullable();
            $table->text('building_integrated_plan_desc')->nullable();
            $table->enum('employing_classroom_applications_rate', [1, 2, 3, 4, 5])->nullable();
            $table->text('employing_classroom_applications_desc')->nullable();
            $table->enum('creating_educational_environment_rate', [1, 2, 3, 4, 5])->nullable();
            $table->text('creating_educational_environment_desc')->nullable();
            $table->enum('department_student_contributions_inquiries_rate', [1, 2, 3, 4, 5])->nullable();
            $table->text('department_student_contributions_inquiries_desc')->nullable();
            $table->enum('managing_learning_time_rate', [1, 2, 3, 4, 5])->nullable();
            $table->text('managing_learning_time_desc')->nullable();
            $table->enum('student_interaction_level_rate', [1, 2, 3, 4, 5])->nullable();
            $table->text('student_interaction_level_desc')->nullable();
            $table->enum('student_achievement_level_rate', [1, 2, 3, 4, 5])->nullable();
            $table->text('student_achievement_level_desc')->nullable();
            $table->timestamps();

            $table->foreign('classVisit_id')->references('id')->on('class_room_visit_sessions')->onDelete('cascade');

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('class_visit_rates');
    }
};
