<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('internal_circulars', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('school_id')->nullable();
            $table->string('title')->nullable();
            $table->text('details')->nullable();
            $table->string('date')->nullable();
            $table->enum('date_type', ['coptic', 'hijri'])->nullable();
            $table->string('day')->nullable();
            $table->timestamps();
            $table->softDeletes();

            // Foreign key constraint for parent school
            $table->foreign('school_id')->references('id')->on('schools')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('internal_circulars');
    }
};
