<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('teacher_schedul_data', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('teacher_schedule_id');
            $table->unsignedBigInteger('school_employee_id');
            $table->unsignedBigInteger('subject_id');
            $table->unsignedBigInteger('period_id');
            $table->unsignedBigInteger('day_id');
            $table->foreign('teacher_schedule_id')->references('id')->on('teacher_schedules')->onDelete('cascade');
            $table->foreign('school_employee_id')->references('id')->on('school_employees')->onDelete('cascade');
            $table->foreign('period_id')->references('id')->on('periods')->onDelete('cascade');
            $table->foreign('subject_id')->references('id')->on('subjects')->onDelete('cascade');
            $table->timestamps();
            $table->softDeletes();

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('teacher_schedul_data');
    }
};
