<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('proceeds', function (Blueprint $table) {
            $table->id();
            $table->enum('proceed_type', ['destruction', 'loss', 'incident', 'general']);
            $table->string('date', 150)->nullable();
            $table->enum('date_type', ['coptic', 'hijri']);
            $table->string('title', 150);
            $table->text('text')->nullable();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('proceeds');
    }
};
