<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSchoolFacilitiesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('school_facilities', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('school_id');
            $table->foreign('school_id')->references('id')->on('schools')->onDelete('cascade');
            $table->enum('building_type', ['rental', 'governmental'])->nullable();
            $table->enum('building_status', ['dilapidated', 'well_equipped','good'])->nullable();
            $table->integer('n_class')->default(0);
            $table->integer('n_bathrooms')->default(0);
            $table->integer('n_floors')->default(0);
            $table->integer('n_team_rooms')->default(0);
            $table->integer('n_management_rooms')->default(0);
            $table->integer('n_computer_laps')->default(0);
            $table->integer('n_science_laps')->default(0);
            $table->integer('n_ware_houses')->default(0);
            $table->integer('n_learning_resources')->default(0);
            $table->integer('n_activity_rooms')->default(0);
            $table->integer('n_meeting_rooms')->default(0);
            $table->integer('n_sport_houses')->default(0);
            $table->integer('n_theaters')->default(0);
            $table->integer('n_playgrouonds')->default(0);
            $table->integer('n_outdoors_court')->default(0);
            $table->timestamp('deleted_at')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('school_facilities');
    }
}
