<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCurrentWorksTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('current_works', function (Blueprint $table) {
            $table->bigIncrements('id');  // UNSIGNED BIGINT, auto-incrementing primary key
            $table->string('job_title', 150)->nullable();  // VARCHAR(150), nullable
            $table->unsignedBigInteger('assignment_category_id')->nullable();
            $table->integer('assignment_form_number')->nullable();
            $table->timestamps();  // Adds 'created_at' and 'updated_at' columns
            $table->softDeletes();

            $table->foreign('assignment_category_id')->references('id')->on('assignments_categories')->onDelete('cascade');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('current_works');
    }
}
