<?php

namespace Database\Factories\ManagerDashboard\Tables\ShiftSchedule;

use App\Models\SchoolSemester;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\ManagerDashboard\Tables\ShiftSchedule\WeekelyShift>
 */
class WeekelyShiftFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $weekNames = ['الأول', 'الثاني', 'الثالث', 'الرابع','الخامس','السادس','السابع','الثامن','التاسع','العاشر','الحادى عشر','الثاني عشر','الثالث عشر','الرايع عشر','الخامس عشر'];
        return [
            'school_id' => 1,
            'semester_id' =>SchoolSemester::inRandomOrder()->first()->id,
            'week_name' => $this->faker->randomElement($weekNames),
            'day_of_week' => $this->faker->dayOfWeek, // or you can use a fixed set of days
            'date' => $this->faker->date,
            'date_type' => $this->faker->randomElement(['coptic', 'hijri']),
        ];
    }
}
