<?php

namespace Database\Factories\AdminDashboard\School;

use App\Models\AdminDashboard\EducationalDepartment\EducationalDepartment;
use App\Models\AdminDashboard\EducationalOffice\EducationalOffice;
use App\Models\AdminDashboard\School\SchoolGrade;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\AdminDashboard\School\School>
 */
class SchoolFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'user_id'=> User::inRandomOrder()->first()->id,
            'shift' => $this->faker->randomElement(['morning','evening','night']),
            'gender' => $this->faker->randomElement(['male','female']),
            'school_grade_id' =>  SchoolGrade::inRandomOrder()->first()->id,
            'name' =>  $this->faker->name, 
            'education_type' =>  $this->faker->randomElement(['governmental','family']),
            'education_department_id' => EducationalDepartment::inRandomOrder()->first()->id,
            'educational_office_id' => EducationalOffice::inRandomOrder()->first()->id,
           
        ];
    }
}
