<?php

namespace Database\Factories\AdminDashboard\School;

use App\Models\AdminDashboard\School\School;
use App\Models\AdminDashboard\School\Subject;
use App\Models\ManagerDashboard\TeamAndCommitteeMeetings\Committee;
use App\Models\ManagerDashboard\TeamAndCommitteeMeetings\Team;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Teacher>
 */
class MeetingFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $team = Team::inRandomOrder()->first();
        $committee = Committee::inRandomOrder()->first();

        return [
            'name' => $this->faker->name,
            'model_type' => $this->faker->randomElement(['committees','teams']),
            'model_id' => $this->faker->randomElement([$team->id,$committee->id]),
            'school_id' => 1,
            'meeting_type' => $this->faker->randomElement(['urgent','periodic']),
            'date' => fake()->date(),
            'date_type' => $this->faker->randomElement(['coptic','hijri']),
            'start_time' => $this->faker->time($format = 'H:i'),
            'end_time' => $this->faker->time($format = 'H:i'),
            'place' => fake()->city(), 
            'date_type' => $this->faker->randomElement(['coptic','hijri']),
            'attendances_count' => $this->faker->numberBetween(20, 40),
            'target_audience' => $this->faker->word(),
            'meeting_status' => $this->faker->randomElement(['completed','not_completed','drafted']),
        ];
    }
}
