<?php

namespace Database\Factories\AdminDashboard\Products;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Product>
 */
class ProductFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'name'=> fake()->name,
            'type'=>fake()->randomElement(['subscription', 'sms']),
            'price'=> fake()->randomFloat(2,1,1000),
            'description'=> fake()->sentence()
        ];
    }
}
