<?php

namespace Database\Factories\AdminDashboard\Coupons;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Coupon>
 */
class CouponFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            
            'code' => strtoupper(Str::random(10)),
            'discount_type' => $this->faker->randomElement(['percentage','fixed']),
            'discount_value' => $this->faker->numberBetween(10, 50),
            'coupon_status' => $this->faker->randomElement(['active', 'expired']),
            'expiration_date' =>  $this->faker->dateTimeBetween('+1 month', '+1 year')->format('Y-m-d'),
            'expiration_date_type' => $this->faker->randomElement(['hijri', 'coptic']),
            'minimum_purchase' => $this->faker->numberBetween(100, 500),
            'maximum_purchase_limit' => $this->faker->optional()->numberBetween(200, 1000),
            'usage_status_for_users' => $this->faker->randomElement(['limited', 'unlimited']),
            'usage_limit_per_coupon' => $this->faker->optional()->numberBetween(1, 10),
            'usage_status_for_user' => $this->faker->randomElement(['limited', 'unlimited']),
            'usage_limit_per_user'  => $this->faker->optional()->numberBetween(1, 5),
        ];
    }
}
