<?php

return [

'backup' => [
    'name' => env('APP_NAME', 'laravel-backup'),

    'source' => [
        'files' => [
            'include' => [
                base_path('storage/backups'),
            ],
            'exclude' => [
                base_path('vendor'),
                base_path('node_modules'),
            ],
            'follow_links' => false,
            'ignore_unreadable_directories' => false,
            'relative_path' => null,
        ],

        'databases' => [
            'mysql',
        ],
    ],

    // Disable database dump compression
    'database_dump_compressor' => null,

    // Set the extension for the database dump file
    'database_dump_file_extension' => 'sql',

    // Set the filename base (could be 'database' or 'connection')
    'database_dump_filename_base' => 'database',

    'destination' => [
        // Disable compression to avoid creating a zip file
        'compression_method' => false,
        'use_single_transaction' => true,
        'compression_level' => 9,
        'filename_prefix' => '',  // You can leave this empty or set a prefix
        'disks' => [
            'local', // Ensure the correct disk is used
        ],
    ],

    'temporary_directory' => storage_path('app/backup-temp'),

    'password' => env('BACKUP_ARCHIVE_PASSWORD'),

    'encryption' => 'default',

    'tries' => 1,
    'retry_delay' => 0,
],

];
