<?php

namespace App\Strategies;

use App\Helpers\Helper;
use App\Models\ManagerDashboard\Assignments\Assignment;

class NamozegAssignmentSchoolEmployees implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version,$type=null)
    {

        $query = Assignment::with(['job', 'assignmentEmployees.employee.specialization'])
            ->where('school_id', $school->id)
            ->where('namazeg_version_id', $namozeg_version->id)
            ;

        if($type == 'trashed') {
            $query->withTrashed();
        }

        $assignmentSchoolEmployee = $query->firstOrFail();
     
        return [
            'id' => $assignmentSchoolEmployee->job->id,
            'name' => $assignmentSchoolEmployee->job->job_title ?? $assignmentSchoolEmployee->job->name,
            'assignment_form_number' => $assignmentSchoolEmployee->job->assignment_form_number ?? null,
            'assignment' => [
                'id' => $assignmentSchoolEmployee->id,
                'namozeg_serial_number' => $assignmentSchoolEmployee->namozegVersion?->serial_number,
                'date' => $assignmentSchoolEmployee->date ?? 'No date',
                'date_options' => Helper::getDateOptions($assignmentSchoolEmployee->date, $assignmentSchoolEmployee->type),
                'employees' => $assignmentSchoolEmployee->assignmentEmployees->map(function ($assignmentEmployee) {
                    return [
                        'employee_id' => $assignmentEmployee->employee?->id,
                        'name' => $assignmentEmployee->employee?->name ?? 'No name',
                        'civil_record_number' => $assignmentEmployee->employee?->ssn ?? 'No SSN',
                        'specialization' => $assignmentEmployee->employee?->specialization->title ?? 'No specialization',
                    ];
                }),
            ],
        ];
    }
}
