<?php

namespace App\Strategies;

use App\Http\Resources\ManagerDashboard\Exams\NamazegPlans\MonitorDailyObserversResource;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\Exams\NamazegPlans\MonitorDistributions\DistribtionAssignmentMonitor;
use App\Helpers\Helper;

class Namozeg82Handler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version, $type = null)
    {

        $query = DistribtionAssignmentMonitor::whereHas('dailyObserve', function ($query) use ($namozeg_version, $school) {
            $query->where('namazeg_version_id', $namozeg_version->id)
                ->where('school_id', $school->id);
        });

        if ($type == 'trashed') {
            $query->withTrashed();
        }

        $monitor = $query->firstOrFail();

        $school_manager = SchoolEmployee::select('id', 'name')
            ->where('school_id', $school->id)
            ->where('current_work_id', 1)
            ->first();

        $distribtionAssignmentMonitor = new MonitorDailyObserversResource($monitor);
        // Get current school year and semester
        $current_school_year = $school->current_school_year;
        $current_semester = Helper::getCurrentSchoolSemester()['name'];

        $commonResponse = [
            'current_school_year' => $current_school_year,
            'current_semester' => $current_semester,
            'floor' => 'الاول',
        ];
        return [
            'data' => $distribtionAssignmentMonitor,
            'school_manager' => $school_manager,
            'school_context' => $commonResponse,
        ];


    }
}
