<?php

namespace App\Strategies;

use App\Helpers\Helper;
use App\Http\Resources\ManagerDashboard\Exams\SupervisionCommittees\CorrectionAssignmentResource;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\Exams\SupervisionCommittees\CorrectionAssignment;

class Namozeg67Handler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version, $type = null)
    {

        $assignments =   CorrectionAssignment::with('members')->where('namazeg_version_id', $namozeg_version->id)->firstOrFail();
        if ($type == 'trashed') {
            $assignments->withTrashed();
        }
        $data =  new CorrectionAssignmentResource($assignments);

        // Get current school year and semester
        $current_school_year = $school->current_school_year;
        $current_semester = Helper::getCurrentSchoolSemester()['name'];

        $commonResponse = [
            'current_school_year' => $current_school_year,
            'current_semester' => $current_semester,
            'floor' => 'الاول',
        ];

        $school_manager = SchoolEmployee::select('id', 'name')
            ->where('school_id', $school->id)
            ->where('current_work_id', 1)
            ->first();


        return
            [
                'data' =>  $data,
                'school_context' => $commonResponse,
                'school_manager' =>  $school_manager
            ];
    }
}
