<?php

namespace App\Strategies;

use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\SupervisionSchedul;
use Carbon\Carbon;

class Namozeg49Handler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version,$type=null)
    {
        $query = SupervisionSchedul::with('namozegVersion')->where('namazeg_version_id', $namozeg_version->id);

        if($type == 'trashed') {
            $query->withTrashed();
        }

        $supervision = $query->firstOrFail();
        $groupedData = $supervision->supervisors->groupBy('day_id');
        $follow_groupedData = $supervision->follow_supervisors?->groupBy('day_id');

        $formattedData = $groupedData->map(function ($dayData, $dayId) use ($follow_groupedData) {
            return [
                'day_id' => $dayId,
                'day' => $dayData->first()->day_name->name,
                'followers' => $follow_groupedData->isNotEmpty() ? $follow_groupedData[$dayId]->map(function ($entry) {
                    return [
                        'id' => $entry->id,
                        'school_employee_id' => $entry->school_employee_id,
                        'school_employee' => $entry->employee->name
                    ];
                })->values() : [],

                'data' => $dayData->groupBy('floor_id')->map(function ($floorData, $floorId) {
                    return [
                        'floor_id' => $floorId,
                        'floor' => $floorData->first()->floor_name->name,
                        'supervisors' => $floorData->map(function ($entry) {
                            return [
                                'id' => $entry->id,
                                'school_employee_id' => $entry->school_employee_id,
                                'school_employee' => $entry->employee->name
                            ];
                        })->values()
                    ];
                })->values()
            ];
        })->values();

        // وكيل الشئون المدرسية
        $supervisor_name = SchoolEmployee::where('school_id', $supervision->school_id)->where('current_work_id', 8)->first()?->name;
        $manager_name = SchoolEmployee::where('school_id', $supervision->school_id)->where('current_work_id', 1)->first()?->name;

        return [
            'title' => $supervision->title,
            'semester' => $supervision->semester?->name,
            'manager_name' => $manager_name,
            'supervisor_name' => $supervisor_name,
            'form_number' => $supervision->namozegVersion->namozeg->form_number,
            'serial_number' => $supervision->namozegVersion->serial_number,
            'created_at' => $supervision->supervisors ? $supervision->created_at->format('Y/m/d') : __('api.not_created_yet'),
            'supervison' => $formattedData
        ];
    }
}
