<?php

namespace App\Strategies;

use App\Helpers\Helper;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\AdminDashboard\School\SchoolSemester;
use App\Models\AdminDashboard\School\SemesterWeekDay;
use App\Models\ManagerDashboard\Namazeg\NamazegVersion;
use App\Models\ManagerDashboard\Tables\ShiftSchedule\ShiftSchedule;
use App\Models\ManagerDashboard\Tables\ShiftSchedule\ShiftTeacher;
use App\Models\ManagerDashboard\Tables\WaitingPeriodsSchedule\WaitingPeriodsSchedule;
use Carbon\Carbon;

class Namozeg48Handler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version,$type=null)
    {

        $query = ShiftTeacher::query();

        if($type == 'trashed') {
            $query->withTrashed();
        }

        $namozeg = $query->where('namazeg_version_id',$namozeg_version->id)->firstOrFail();

        $teacherIds = explode(',',$namozeg->school_employee_id);
        $teachers = SchoolEmployee::whereIn('id', $teacherIds)->get(['id', 'name']);

        $mappedTeachers = $teachers->map(function ($teacher) {
            return [
                'name' => $teacher->name
            ];
        });

        $shiftSchedule= ShiftSchedule::find($namozeg->shift_schedule_id);

        $schoolManager = SchoolEmployee::where('school_id' , $school->id)->first();

        return [
            'school_year' => Helper::getSchoolYear(),
            //'school_year' =>substr(Helper::getSchoolYear(), -2) ,
            'semester' => $shiftSchedule->semester?->name,
            'date' => $namozeg->day?->semesterWeekDay?->date,
            'day' => $namozeg->day?->semesterWeekDay?->day?->name,
            'teachers'=>$mappedTeachers,
        ];





    }
}
