<?php

namespace App\Strategies;

use App\Helpers\Helper;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\Circulars\InternalCircular;

class Namozeg42Handler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version, $type = null)
    {
        $query = InternalCircular::with('teachers')->where('namazeg_version_id', $namozeg_version->id);

        if ($type == 'trashed') {
            $query->withTrashed();
        }

        $namozeg = $query->firstOrFail();
        $teachers = $namozeg->teachers()->get()->map(function ($item) {
            return $item->name;
        });
        $manager_name = SchoolEmployee::where('school_id', $school->id)->where('current_work_id', 1)->first()?->name;

        return [
            'form_number' => $namozeg_version->namozeg->form_number,
            'serial_number' => $request->serial_number,
            'date' => substr(Helper::getHijri($namozeg->date), 2),
            'about' => $namozeg->title,
            'to' => $teachers,
            'content' => $namozeg->details,
            'manager_name' => $manager_name,
        ];
    }
}
