<?php

namespace App\Strategies;

use App\Helpers\Helper;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\OfficialSpeeches\Letter;
use Carbon\Carbon;

class Namozeg41Handler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version, $type = null)
    {
        $query = Letter::with('namozegVersion')->where('namazeg_version_id', $namozeg_version->id);

        if ($type == 'trashed') {
            $query->withTrashed();
        }

        $letter = $query->firstOrFail();
        $school_manager = SchoolEmployee::select('id', 'name')
            ->where('school_id', $school->id)
            ->where('current_work_id', 1)
            ->first();

        return [
            'id' => $letter->id,
            'school_id' => $letter->school_id,
            'form_number' => $letter->namozegVersion?->namozeg?->form_number,
            'serial_number' => $letter->namozegVersion?->serial_number,
            'type' => $letter->type,
            'date_type' => $letter->date_type,
            'date' => Carbon::createFromFormat('d/m/Y', $letter->date)->format('d/m/Y'),
            'day' => Carbon::createFromFormat('d/m/Y', $letter->date)->locale('ar')->translatedFormat('l'),
            'date_options' => Helper::getDateOptions($letter->date, $letter->type),
            'title' => $letter->title,
            'letter_for' => $letter->letter_for,
            'details' => $letter->details,
            'school_manager' => $school_manager
        ];
    }
}
