<?php

namespace App\Strategies;

use App\Helpers\Helper;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\TeamAndCommitteeMeetings\Meeting;
use Carbon\Carbon;

class Namozeg3Handler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version, $type = null)
    {
        $query = Meeting::with([
            'members' => function($q) {
                $q->with('employee.currentWork'); // Load the currentWork relationship for each member
            },
            'meetingScheduals',
            'meetingRecommendations'
        ])->where('namazeg_version_id', $namozeg_version->id);
        
        if ($type == 'trashed') {
            $query->withTrashed();
        }
        
        $namozeg = $query->firstOrFail();
        
        $namozeg->disableAccessors();

        $meeting_number = Meeting::where('model_type', $namozeg->model_type)
            ->where('model_id', $namozeg->model_id)
            ->where('meeting_type', $namozeg->meeting_type)
            ->where('created_at', '<=', $namozeg->created_at)
            ->orderBy('created_at', 'ASC')
            ->count();
        
        $members = $namozeg->members->map(function ($item) {
            return [
                'name' => $item->employee->name,
                'job_title' => $item->employee()->first()->currentWork->job_title, // Assuming job_title is directly accessible
                'qualified_title' => $item->assignment_work,
            ];
        })->toArray();
            
        $day = Carbon::createFromFormat('d/m/Y',$namozeg->date)->dayName;
        $manager_name = SchoolEmployee::where('school_id', $school->id  )->where('current_work_id', 1)->first()?->name;

        return [
            'meeting_type' => $namozeg->meeting_type,
            'meeting_number' => $meeting_number,
            'meeting_place' => $namozeg->place,
            'start_time' => $namozeg->start_time,
            'target_audience' => $namozeg->target_audience,
            'attendances_count' => $namozeg->attendances_count,
            'meeting_schedulas' => $namozeg->meetingScheduals,
            'day' => $day,
            'date' => Helper::getDateOptions($namozeg->date, $namozeg->date_type),
            'executed_recommendations' => $namozeg->meetingExcuteedRecommendations,
            'not_executed_recommendations' => $namozeg->meetingNotExcuteedRecommendations,
            'end_time' => $namozeg->end_time,
            'members' => $members,
            'school_manager' => $manager_name,
        ];
    }
}
