<?php

namespace App\Strategies;

use App\Helpers\Helper;
use App\Http\Resources\ManagerDashboard\LetterAndAlart\AlertNotesResource;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\OfficialSpeeches\Alert;
use Carbon\Carbon;

class Namozeg39Handler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version, $type = null)
    {

        $query = Alert::with('namozegVersion')->where('namazeg_version_id', $namozeg_version->id);

        if ($type == 'trashed') {
            $query->withTrashed();
        }

        $alert = $query->firstOrFail();
        $school_manager = SchoolEmployee::select('id', 'name')
            ->where('school_id', $school->id)
            ->where('current_work_id', 1)
            ->first();

        return [
            'id' => $alert->id,
            'school_id' => $alert->school_id,
            'form_number' => $alert->namozegVersion?->namozeg?->form_number,
            'serial_number' => $alert->namozegVersion?->serial_number,
            'teacher' => $alert->employee ? [
                'name' => $alert->employee?->name,
                'ssn' => $alert->employee?->ssn,
                'specialization' => $alert->employee->Specialization?->title
            ] : null,
            'type' => $alert->type,
            'date_type' => $alert->date_type,
            'date' => Carbon::createFromFormat('d/m/Y', $alert->date)->format('d/m/Y'),
            'day' => Carbon::createFromFormat('d/m/Y', $alert->date)->locale('ar')->translatedFormat('l'),
            'date_options' => Helper::getDateOptions($alert->date, $alert->type),
            'notes' => AlertNotesResource::collection($alert->notes), // Ensure 'notes' relationship is loaded
            'school_manager' => $school_manager,
        ];
    }
}
