<?php

namespace App\Strategies;

use App\Helpers\Helper;
use App\Http\Resources\ManagerDashboard\ClassRoomVisit\ClassvisitCardResource;
use App\Http\Resources\ManagerDashboard\ClassRoomVisit\ClassVisitNeedResource;
use App\Http\Resources\ManagerDashboard\ClassRoomVisit\ClassVisitRateResource;
use App\Http\Resources\ManagerDashboard\ClassRoomVisit\ClassVisitRecommendationResource;
use App\Models\ManagerDashboard\ClassRoomVisits\ClassRoomVisitSession;
use App\Models\ManagerDashboard\ClassRoomVisits\ClassVisitCard;
use App\Models\ManagerDashboard\ClassRoomVisits\ClassVisitNeed;
use App\Models\ManagerDashboard\ClassRoomVisits\ClassVisitRate;
use App\Models\ManagerDashboard\ClassRoomVisits\ClassVisitRecommendation;

class Namozeg273Handler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version, $type = null)
    {

        $query = ClassRoomVisitSession::where('rate_namazeg_version_id', $namozeg_version->id);

        if ($type == 'trashed') {
            $query->withTrashed();
        }

        $classRoomVisit = $query->firstOrFail();


        // Retrieve the class visit card
        $classVisitCard = ClassVisitCard::where('classVisit_id', $classRoomVisit->id)->first();
        // Retrieve the class visit rate
        $classVisitRate = ClassVisitRate::where('classVisit_id', $classRoomVisit->id)->first();

        // Retrieve the class visit recommendation
        $classVisitRecommendation = ClassVisitRecommendation::where('classVisit_id', $classRoomVisit->id)->first();

        // Retrieve the class visit needs
        $classVisitNeeds = ClassVisitNeed::where('classVisit_id', $classRoomVisit->id)->get();

        return [
            'class_visit_card' =>  new ClassvisitCardResource($classVisitCard),
            'class_visit_rate' => new ClassVisitRateResource($classVisitRate),
            'class_visit_recommendation' => new ClassVisitRecommendationResource($classVisitRecommendation),
            'class_visit_needs' =>  ClassVisitNeedResource::collection($classVisitNeeds),
        ];
    }
}
