<?php

namespace App\Strategies;

use App\Helpers\Helper;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\Tables\Exams\TableExam;
use App\Models\ManagerDashboard\Tables\Exams\TableExamNamazeg;
use App\Models\ManagerDashboard\Tables\Exams\TableExamInstruction;
use App\Http\Resources\ManagerDashboard\Tables\Exams\TableExamNamazegResource;

use Carbon\Carbon;

class Namozeg251Handler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version,$type=null)
    {
        $tableExamId = TableExamNamazeg::where('namazeg_version_id', $namozeg_version->id)->first()->table_exam_id;
        $tableExam = TableExam::where('id',$tableExamId);

        if($type == 'trashed') {
            $tableExam->withTrashed();
        }

        $namozeg = $tableExam->firstOrFail();

        $schoolManager = SchoolEmployee::where('school_id' , $school->id)->first();
        $educationalAdminstrative = SchoolEmployee::where('school_id' , $school->id)->where('current_work_id',6)->first();
        $studentAdminstrative = SchoolEmployee::where('school_id' , $school->id)->where('current_work_id',7)->first();

        $tableExam = new TableExamNamazegResource($namozeg);

        return [
            'school_year' => Helper::getSchoolYear(),
            'semester' => $namozeg->semester?->name,
            'entsab'=>$namozeg->entsab,
            'table_exam'=>$tableExam,
            'school_manager'=>$schoolManager->name,
            'educational_adminstrative'=>$educationalAdminstrative?->name,
            'student_adminstrative'=>$studentAdminstrative?->name
        ];
    }
}
