<?php

namespace App\Strategies;

use App\Helpers\Helper;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\Tables\Exams\TableExam;
use App\Models\ManagerDashboard\Tables\Exams\TableExamNamazeg;
use App\Models\ManagerDashboard\Tables\Exams\TableExamInstruction;
use App\Models\AdminDashboard\School\ClassName;
use App\Models\AdminDashboard\School\SchoolClass;
use App\Models\ManagerDashboard\Tables\Exams\TableExamDay;
use App\Http\Resources\ManagerDashboard\Tables\Exams\TableExamNamazegResource;
use App\Http\Resources\ManagerDashboard\Tables\Exams\TableExamDayResource;

use Carbon\Carbon;

class Namozeg247Handler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version,$type=null)
    {
        $namozeg = TableExamNamazeg::where('namazeg_version_id', $namozeg_version->id)->first();
        $tableExamId = $namozeg->table_exam_id;
        $tableExam = TableExam::where('id',$tableExamId);

        if($type == 'trashed') {
            $tableExam->withTrashed();
        }

        $tableExam = $tableExam->firstOrFail();


        $classNamCategories = TableExamDay::where('table_exam_id',$tableExamId)->pluck('class_name_category')->unique()->toArray();
        $classNameId = TableExamDay::where('table_exam_id', $tableExamId)->value('class_name_id');
        $className = ClassName::find($classNameId);
        $examTableData=  collect($classNamCategories)->mapWithKeys(function ($classNamCategory) use ($tableExamId){

            $tableExamDays = TableExamDayResource::collection(TableExamDay::where('table_exam_id',$tableExamId)->where('class_name_category',$classNamCategory)->get());
            $data=[

                'tableExamDays'=>$tableExamDays
            ];

            return [$classNamCategory => ['tableExamDays' => $tableExamDays]];

        })->all();

        $tableExamDays = TableExamDay::where('table_exam_id', $tableExamId)->where('class_name_id',$classNameId)->get();
        $tableExamDayLeaveTimes = $tableExamDays->map(function ($tableExamDay) {
            return [
                'day'=>$tableExamDay->semesterWeekDay?->day?->name.'',
                'leave_time'=>$tableExamDay->leave_time?$tableExamDay->leave_time:'',
            ];
        });

        $examInstructions = TableExamInstruction::findOrFail(1);

        return [
            'school_year' => Helper::getSchoolYear(),
            'semester' => $tableExam->semester?->name,
            'class_name'=>$className->name,
            'entsab'=>$tableExam->entsab,
            'table_exam'=>$examTableData,
            'exam_instructions'=>$examInstructions->text,
            'table_exam_days_leave_times'=>$tableExamDayLeaveTimes,

        ];
    }


}
