<?php

namespace App\Strategies;

use App\Helpers\Helper;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\Tables\Exams\TableExam;
use App\Models\ManagerDashboard\Tables\Exams\TableExamNamazeg;
use App\Models\ManagerDashboard\Tables\Exams\TableExamInstruction;
use App\Http\Resources\ManagerDashboard\Tables\Exams\TableExamNamazegResource;

use Carbon\Carbon;

class Namozeg245Handler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version,$type=null)
    {
        $tableExamId = TableExamNamazeg::where('namazeg_version_id', $namozeg_version->id)->first()->table_exam_id;
        $tableExam = TableExam::where('id',$tableExamId);

        if($type == 'trashed') {
            $tableExam->withTrashed();
        }

        $namozeg = $tableExam->firstOrFail();

        $tableExam = new TableExamNamazegResource($namozeg);
        $examInstructions = TableExamInstruction::findOrFail(1);

        return [
            'school_year' => Helper::getSchoolYear(),
            'semester' => $namozeg->semester?->name,
            'entsab'=>$namozeg->entsab,
            'table_exam'=>$tableExam,
            'exam_instructions'=>$examInstructions->text,
        ];
    }
}
