<?php

namespace App\Strategies;

use App\Helpers\Helper;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\Tables\Exams\TableExam;
use App\Models\ManagerDashboard\Tables\Exams\TableExamNamazeg;
use App\Models\ManagerDashboard\Tables\Exams\TableExamInstruction;
use App\Http\Resources\ManagerDashboard\Tables\Exams\TableExamResource;

use Carbon\Carbon;

class Namozeg233Handler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version,$type=null)
    {
        $tableExamId = TableExamNamazeg::where('namazeg_version_id', $namozeg_version->id)->first()->id;
        $tableExam = TableExam::where('id',$tableExamId);

        if($type == 'trashed') {
            $tableExam->withTrashed();
        }

        $namozeg = $tableExam->firstOrFail();

        $schoolManager = SchoolEmployee::where('school_id' , $school->id)->first();
        $tableExam = new TableExamResource($namozeg);
        $examInstructions = TableExamInstruction::findOrFail(1);

        return [
            'school_year' => Helper::getSchoolYear(),
            'semester' => $namozeg->semester?->name,
            'school_manager'=>$schoolManager->name,
            'table_exam'=>$tableExam,
            'exam_instructions'=>$examInstructions->text,
        ];
    }
}
