<?php

namespace App\Strategies;

use App\Helpers\Helper;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\Violations\ViolationStudentPunishment;
use Carbon\Carbon;

class Namozeg222Handler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version, $type = null)
    {
        $punishment = ViolationStudentPunishment::with('VStudentTitle')->where('namazeg_version_id', $namozeg_version->id)->first();
        $student = $punishment->VStudentTitle->ViolationStudent->student;
        $manager_name = SchoolEmployee::where('school_id', $school->id)->where('current_work_id', 1)->first()?->name;
        
        return [
            'form_number' => $namozeg_version->namozeg->form_number,
            'serial_number' => $request->serial_number,
            'student_name' => $student->name,
            'class_name' => $student->schoolClass->className?->name,
            'violation_grade' => $punishment->VStudentTitle->ViolationStudent->violationGrade?->name,
            'manager_name'=> $manager_name,
        ];
    }
}
