<?php

namespace App\Strategies;

use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\AbsenseAndLateness\StudentLatenessProcedureSubItem;

class Namozeg215Handler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version,$type=null)
    {
        $query = StudentLatenessProcedureSubItem::with('mainItem')->where('namozeg_version_id', $namozeg_version->id);

        if($type == 'trashed') {
            $query->withTrashed();
        }

        $namozeg = $query->firstOrFail();
        $student_agent_name = SchoolEmployee::where('school_id', $school->id)->where('current_work_id', 7)->first()?->name;
        
        return [
            'form_number' => $namozeg_version->namozeg->form_number,
            'serial_number' => $request->serial_number,
            'student_name' => $namozeg->mainItem->procedureStudent->student->name,
            'class_name' => $namozeg->mainItem->procedureStudent->student->SchoolClass->className->name,
            'n_lateness_days' => $namozeg->mainItem->procedureStudent->lateness_days,
            'student_agent_name' => $student_agent_name,
        ];
    }
}
