<?php

namespace App\Strategies;

use App\Helpers\Helper;
use App\Models\AdminDashboard\School\SchoolClass;
use App\Models\AdminDashboard\School\Student;
use App\Models\ManagerDashboard\Namazeg\NamazegBooksDelivery;

class Namozeg192Handler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version,$type=null)
    {
        $query = NamazegBooksDelivery::where('namazeg_version_id', $namozeg_version->id);

        if($type == 'trashed') {
            $query->withTrashed();
        }

        $namozeg = $query->firstOrFail();
        $student_names = Student::where('class_id', $namozeg->class_id)->pluck('name')->toArray();
        $school_class = SchoolClass::with('className')->where('id', $namozeg->class_id)->firstOrFail();
        $current_semester = Helper::getCurrentSchoolSemester();

        return [
            'form_number' => $namozeg_version->namozeg->form_number,
            'serial_number' => $request->serial_number,
            'school_name' => $school->name,
            'current_semester' => $current_semester->name,
            'current_school_year' => $school->current_school_year,
            'class_name' => $school_class->className->name,
            'class_number' => $school_class->class_number,
            'day' =>  $namozeg->created_at->translatedFormat('D', 'ar'),
            'date' =>  $namozeg->created_at->format('Y/m/d'),

            'student_names' => $student_names,

        ];
    }
}
