<?php

namespace App\Strategies;

use App\Helpers\Helper;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\Violations\ViolationStudentPunishment;

class Namozeg148Handler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version, $type = null)
    {
        $punishment = ViolationStudentPunishment::with('VStudentTitle')->where('namazeg_version_id', $namozeg_version->id)->first();
        $student = $punishment->VStudentTitle->ViolationStudent->student;
        // $punishment_category = $punishment->VStudentTitle->ViolationStudent->category;
        $violation_type = $punishment->VStudentTitle->ViolationStudent->type;
        $students_supervisor_name = SchoolEmployee::where('school_id', $school->id)->where('current_work_id', 7)->first()?->name;

        return [
            'form_number' => $namozeg_version->namozeg->form_number,
            'serial_number' => $request->serial_number,
            'student_name' => $student->name,
            'class_name' => $student->schoolClass->className?->name,
            'violation_grade' => $punishment->VStudentTitle->ViolationStudent->violationGrade?->name,
            'violation_type' => $violation_type ? $violation_type->name : $punishment->VStudentTitle->ViolationStudent->other_type,
            'students_supervisor'=> $students_supervisor_name
        ];
    }
}
