<?php

namespace App\Strategies;

use App\Helpers\Helper;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\Namazeg\NamazegAssignProfessionalCommunities;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;

class Namozeg136Handler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version,$type=null)
    {
        $query = NamazegAssignProfessionalCommunities::with('specialization', 'assign_employee')->where('namazeg_version_id', $namozeg_version->id);
        
        if($type == 'trashed') {
            $query->withTrashed();
        }
        
        $namozeg = $query->firstOrFail();
        $employees =  $namozeg->assign_employee->map(function ($employee) {
            return new Collection([
                'name' => $employee->employee->name,
                'specilization' => $employee->employee?->specialization?->title,
                'classes' => $employee->class_teaching,
                'assignment_details' => $employee->assignment_details,
            ]);
        });

        $manager_name = SchoolEmployee::where('school_id', $school->id)->where('current_work_id', 1)->first()?->name;
        return [
            'form_number' => $namozeg_version->namozeg->form_number,
            'serial_number' => $request->serial_number,
            'current_school_year' => $school->current_school_year,
            'date' => Helper::getDateOptions($namozeg->date, 'coptic'),
            'start_date' => Helper::getDateOptions($namozeg->start_date, 'coptic'),
            'date_day'=>   Carbon::createFromFormat('d/m/Y', $namozeg->date)->translatedFormat('D', 'ar'),
            'manager_name' => $manager_name,
            'specialization' => $namozeg->specialization->title,
            'employees' => $employees,
        ];
    }
}
