<?php

namespace App\Models;

use App\Models\AdminDashboard\School\School;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\Settings\BusinessAccountData;
use DateTime;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Tymon\JWTAuth\Contracts\JWTSubject;
use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Spatie\Permission\Traits\HasRoles;
use Illuminate\Contracts\Auth\MustVerifyEmail;


class User extends Authenticatable implements JWTSubject , MustVerifyEmail
{
    use HasFactory, HasRoles;

    protected $table = 'users';


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'status',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];


    /**
     * Get the identifier that will be stored in the subject claim of the JWT.
     *
     * @return mixed
     */
    public function getJWTIdentifier()
    {
        return $this->getKey();
    }

    /**
     * Return a key value array, containing any custom claims to be added to the JWT.
     *
     * @return array
     */
    public function getJWTCustomClaims()
    {
        return [];
    }


    public function employee()
    {
        return $this->hasOne(SchoolEmployee::class);
    }


    //  -------------  For Website Only -------------------------
    public function my_all_notification($school_id = null)
    {
        return $this->hasMany(NotificationReceptor::class)
            ->orderBy('id', 'Desc')
            ->whereHas('notification', function ($query) {
                $query->where('notification_type', 'website');
            })
            ->where('school_id', $school_id ?? $this->employee?->school_id)
            ->with('notification');
    }

    public function my_bell_count_notification($school_id = null)
    {
        return $this->hasMany(NotificationReceptor::class)
            ->orderBy('id', 'desc')
            ->whereHas('notification', function ($query) {
                $query->where(function ($q) {
                    // Check if the date is today and the time is current
                    $q->where(function ($q2) {
                        $q2->whereRaw("STR_TO_DATE(date, '%d/%m/%Y') = CURDATE()")
                            ->whereRaw("TIME(time) <= CURTIME()"); // assuming 'notification_time' stores the time
                    })
                        ->orWhereNull('date'); // Include notifications with no date
                })
                    ->where('notification_type', 'website')
                    ->where('type', 'bell');
            })
            ->where('school_id', $school_id ?? $this->employee?->school_id)
            ->with('notification');
    }
    public function my_bell_notification($school_id = null)
    {
        return $this->hasMany(NotificationReceptor::class)
            ->orderBy('id', 'desc')
            ->whereHas('notification', function ($query) {
                $query->where(function ($q) {
                    $q->where(function ($q2) {
                        $q2->whereRaw("STR_TO_DATE(date, '%d/%m/%Y') = CURDATE()")
                            ->whereRaw("TIME(time) <= CURTIME()");
                    })
                        ->orWhereNull('date');
                })
                    ->where('notification_type', 'website')
                    ->whereIn('type', ['bell', 'priority_tape']);
            })
            ->where('school_id', $school_id ?? $this->employee?->school_id)
            ->with('notification');
    }
    public function my_normal_tape_notification($school_id = null)
    {
        return $this->hasMany(NotificationReceptor::class)
            ->orderBy('id', 'Desc')
            ->whereHas('notification', function ($query) {
                $query->where(function ($q) {
                    $q->where(function ($q2) {
                        $q2->whereRaw("STR_TO_DATE(date, '%d/%m/%Y') = CURDATE()")
                            ->whereRaw("TIME(time) <= CURTIME()");
                    })
                        ->orWhereNull('date');
                })
                    ->where('notification_type', 'website')
                    ->whereIn('type', ['normal_tape']);
            })
            ->where('seen', 0)
            ->where('school_id', $school_id ?? $this->employee?->school_id)
            ->with('notification');
    }
    public function my_priority_tape_notification($school_id = null)
    {
        return $this->hasMany(NotificationReceptor::class)
            ->orderBy('id', 'Desc')
            ->whereHas('notification', function ($query) {
                $query->where(function ($q) {
                    $q->where(function ($q2) {
                        $q2->whereRaw("STR_TO_DATE(date, '%d/%m/%Y') = CURDATE()")
                            ->whereRaw("TIME(time) <= CURTIME()");
                    })
                        ->orWhereNull('date');
                })
                    ->where('notification_type', 'website')
                    ->whereIn('type', ['priority_tape']);
            })
            ->where('seen', 0)
            ->where('school_id', $school_id ?? $this->employee?->school_id)
            ->with('notification');
    }


    public function schools()
    {
        return $this->hasMany(School::class, 'user_id', 'id');
    }
    public function user_schools()
    {
        return $this->hasMany(SchoolEmployee::class, 'user_id')->where('school_id', '!=', null);
    }

    public function getLastSeen()
    {

        $now = new DateTime(date('Y-m-d H:i:s'));
        $adate = new DateTime($this->last_seen);
        $interval = $adate->diff($now);

        $xxxx = '';
        if ($interval->y > 0) {
            $xxxx = 'منذ ' . $interval->y . ' سنوات';
        } else if ($interval->m > 0) {
            $xxxx = 'منذ ' . $interval->m . ' أشهر';
        } else if ($interval->d > 0) {
            $xxxx = 'منذ ' . $interval->d . ' أيام';
        } else if ($interval->h > 0) {
            $xxxx = 'منذ ' . $interval->h . ' ساعات, ';
            $xxxx .= 'و ' . $interval->i . ' دقائق';
        } else {
            $xxxx = 'منذ ' . $interval->i . ' دقائق';
        }

        return $xxxx;
    }

    public function bussinessData()
    {
        return  $this->hasOne(BusinessAccountData::class);
    }

    // get manager_id
    public function getManagerIdAttribute()
    {
        if ($this->user_type == "super_admin") {
            return null;
        } elseif ($this->user_type == "school_manager") {
            if($this->employee->current_work_id==1){
                $manager_id = $this->id;
            }else{
                $manager_id = SchoolEmployee::where('school_id', $this->employee->school_id)
                ->where('current_work_id', 1)
                ->first()->user_id;
            }
            return $manager_id;
        } elseif ($this->user_type == "teacher") {
            $school_id = SchoolEmployee::where('user_id', $this->id)->first()->school_id;
            $manager_id = SchoolEmployee::where('school_id', $school_id)
                ->where('current_work_id', 1)
                ->first()->user_id;
            return $manager_id;
        }

    }
}
