<?php

namespace App\Models\ManagerDashboard\Tables\ShiftSchedule;

use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\AdminDashboard\School\SchoolSemester;
use App\Models\Day;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ShiftTeacher extends Model
{
    use HasFactory,softDeletes;

    protected $table = 'shift_teachers';
    protected $guarded = [];
    public $timestamps = false;

    public function teacher(){
        return $this->belongsTo(SchoolEmployee::class,'school_employee_id','id');
    }

    public function semester()
    {
        return $this->belongsTo(SchoolSemester::class);
    }

    public function day()
    {
        return $this->belongsTo( ShiftScheduleDay::class,'shift_schedule_day_id')->with('semesterWeekDay');
    }

}
