<?php

namespace App\Models\ManagerDashboard\Tables\ClassRoomVisits;

use App\Models\AdminDashboard\School\Period;
use App\Models\AdminDashboard\School\SchoolClass;
use App\Models\AdminDashboard\School\SchoolSemester;
use App\Models\AdminDashboard\School\Subject;
use App\Models\ManagerDashboard\Tables\Teacher;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\Namazeg\NamazegVersion;
use Illuminate\Database\Eloquent\SoftDeletes;

class ClassroomVisit extends Model
{
    use HasFactory,SoftDeletes;

    protected $table = 'classroom_visits';

    protected $guarded = [];

    public function visitingTeacher()
    {
        return $this->belongsTo(SchoolEmployee::class,'visiting_teacher_id');
    }

    public function visitedTeacher()
    {
        return $this->belongsTo(SchoolEmployee::class,'visited_teacher_id');
    }

    public function period()
    {
        return $this->belongsTo(Period::class);
    }
    public function subject()
    {
        return $this->belongsTo(Subject::class);
    }

    public function class()
    {
        return $this->belongsTo(SchoolClass::class,'school_class_id')->with('className');    
    }

    public function className()
    {
        return  SchoolClass::where('class_name_id',$this->class_id)->first();
    }

    public function semester()
    {
        return $this->belongsTo(SchoolSemester::class,'semester_id');
    }

    public function namozegVersion()
    {
        return $this->belongsTo(NamazegVersion::class, 'namazeg_version_id')->with('namozeg');
    }

    public function semesterNamozegVersion()
    {
        return $this->belongsTo(NamazegVersion::class, 'semester_namazeg_version_id')->with('namozeg');
    }


}
