<?php

namespace App\Models\ManagerDashboard\Reports\ManagerReports;

use App\Models\AdminDashboard\School\SchoolSemester;
use App\Models\Week;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\ManagerDashboard\Namazeg\NamazegVersion;
use Illuminate\Database\Eloquent\SoftDeletes;

class AbsentLate extends Model
{
    use SoftDeletes;
    
    protected $table = 'report_absent_lates';

    protected $guarded = [];

    public function namozegVersion()
    {
        return $this->belongsTo(NamazegVersion::class, 'namazeg_version_id')->with('namozeg');
    }

    public function semester(){
        return $this->belongsTo(SchoolSemester::class);
    }

    public function week(){
        return $this->belongsTo(Week::class);
    }
}
