<?php

namespace App\Models\ManagerDashboard\Namazeg\Violations;

use App\Helpers\Helper;
use App\Models\AdminDashboard\School\Student;
use App\Models\ManagerDashboard\Namazeg\NamazegVersion;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class NamazegMinusStudentDescion extends Model
{
    use HasFactory, SoftDeletes;
    protected $guarded = [];
    public function namozegVersion()
    {
        return $this->belongsTo(NamazegVersion::class, 'namazeg_version_id')->with('namozeg');
    }

    public function degree()
    {
        return $this->belongsTo(StudentViolationDegrees::class, 'namazeg_version_id','namazeg_version_id');
    }
    public function student()
    {
        return $this->belongsTo(Student::class, 'student_id');
    }



    public function setReturnConditionAttribute($value)
    {
        $this->attributes['return_condition'] = json_encode($value);
    }
    public function getReturnConditionAttribute($value)
    {
        return $this->attributes['return_condition'] = json_decode($value);
    }

}
