<?php

namespace App\Models\ManagerDashboard\Namazeg\Violations;

use App\Models\AdminDashboard\School\Student;
use App\Models\ManagerDashboard\Namazeg\NamazegVersion;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class NamazegIncidentProceed extends Model
{
    //  محضر ضبط الواقعة
    use HasFactory,SoftDeletes;
    protected $guarded = [];
    public function namozegVersion()
    {
        return $this->belongsTo(NamazegVersion::class, 'namazeg_version_id')->with('namozeg');
    }

    public function witnesses(){
        return $this->hasMany(NamazegIncidentProceedWitness::class, 'namazeg_incident_proceed_id')->with('employee');
    }
    public function student(){
        return $this->belongsTo(Student::class, 'student_id')->with('school');
    }

    public function setTypeAttribute($value)
    {
        $this->attributes['type'] = json_encode($value);
    }
    public function getTypeAttribute($value)
    {
        return $this->attributes['type'] = json_decode($value);
    }


}
