<?php

namespace App\Models\ManagerDashboard\Namazeg;

use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\AdminDashboard\School\Specialization;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class NamazegAssignProfessionalCommunities extends Model
{
    // تكليف فريق مجتمعات التعلم المهنية
    use HasFactory, SoftDeletes;
    protected $guarded = [];
    public function namozegVersion()
    {
        return $this->belongsTo(NamazegVersion::class, 'namazeg_version_id')->with('namozeg');
    }
    public function assign_employee()
    {
        return $this->hasMany(NamazegAssignProfessionalCommunitiesEmployee::class, 'namazeg_assign_id')->with('employee');
    }
    public function specialization()
    {
        return $this->belongsTo(Specialization::class, 'specialize_id');
    }
}
